package com.hero.model;

import java.awt.Toolkit;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */
public class MultiplierDocument extends PlainDocument {

    private static final long serialVersionUID = 2456422152189379899L;

    double max = 99;

    double min = 99;

    boolean quarterAllowed;

    boolean halfAllowed;

    public MultiplierDocument(double max, double min) {
        super();
        this.max = max;
        this.min = min;
        quarterAllowed = true;
        halfAllowed = true;
    }

    public MultiplierDocument(double max, double min, boolean quarter,
            boolean half) {
        super();
        this.max = max;
        this.min = min;
        quarterAllowed = quarter;
        halfAllowed = half;
        if (quarter) {
            halfAllowed = true;
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a)
            throws BadLocationException {
        if (str == null) {
            return;
        }
        if (str.length() == 0) {
            return;
        }
        for (int i = 0; i < str.length(); i++) {
            if (!(Character.isDigit(str.charAt(i)) || str.charAt(i) == 'x'
                    || str.charAt(i) == '-' || str.charAt(i) == '/' || str
                    .charAt(i) == ' ')) {
                if (!(i == 0 && offs == 0)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
        }
        StringBuffer holder = new StringBuffer(getText(0, getLength()));
        holder.insert(offs, str);
        String check = holder.toString();
        try {
            int mult = 1;
            int number = 0;
            int numerator = 0;
            int denomenator = 0;
            if (!check.toLowerCase().startsWith("x")) {
                char numCheck = check.charAt(0);
                if (!Character.isDigit(numCheck)) {
                    throw new Exception("1");
                }
            } else {
                check = check.substring(1, check.length());
            }
            if (check.indexOf(" ") == 0) {
                throw new Exception("2");
            }
            if (check.indexOf(" ") > 0) {
                if (!quarterAllowed && !halfAllowed) {
                    throw new Exception("13"); // no fractions
                }
                number = Integer.parseInt(check
                        .substring(0, check.indexOf(" ")));
                if (mult * number > max) {
                    throw new Exception("3");
                }
                if (number * mult < min) {
                    throw new Exception("4");
                }
                check = check.substring(check.indexOf(" ") + 1, check.length());
                if (check.indexOf(" ") >= 0) {
                    throw new Exception("5");
                }
                if (check.indexOf("/") == 0) {
                    throw new Exception("6");
                } else if (check.indexOf("/") > 0) {
                    numerator = Integer.parseInt(check.substring(0, check
                            .indexOf("/")));
                    if (numerator <= 0 || numerator > 3) {
                        throw new Exception("7");
                    }
                    if (!quarterAllowed && !(numerator == 1)) {
                        throw new Exception("14");
                    }
                    if (check.indexOf("/") < check.length() - 1) {
                        denomenator = Integer.parseInt(check.substring(check
                                .indexOf("/") + 1, check.length()));
                        if (!(denomenator == 2 || denomenator == 4)) {
                            throw new Exception("8");
                        }
                        if (!quarterAllowed && !(denomenator == 2)) {
                            throw new Exception("15");
                        }
                    }
                }
            } else if (check.indexOf("/") == 0) {
                throw new Exception("9");
            } else if (check.indexOf("/") > 0) {
                if (!quarterAllowed && !halfAllowed) {
                    throw new Exception("16");
                }
                numerator = Integer.parseInt(check.substring(0, check
                        .indexOf("/")));
                if (numerator <= 0 || numerator > 3) {
                    throw new Exception("10");
                }
                if (!quarterAllowed && !(numerator == 1)) {
                    throw new Exception("17");
                }
                if (check.indexOf("/") < check.length() - 1) {
                    denomenator = Integer.parseInt(check.substring(check
                            .indexOf("/") + 1, check.length()));
                    if (!(denomenator == 2 || denomenator == 4)) {
                        throw new Exception("11");
                    }
                    if (!quarterAllowed && !(denomenator == 2)) {
                        throw new Exception("18");
                    }
                }
            } else if (check.length() > 0) {
                int numCheck = Integer.parseInt(check);
                if (numCheck <= 0 || numCheck > 3) {
                    numCheck = numCheck * mult;
                    if (numCheck < min || numCheck > max) {
                        throw new Exception("12");
                    }
                }
            }
        } catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.insertString(offs, str, a);
    }
}